
<?php $__env->startSection('title', __('Transaction List')); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between gy-2 gx-3">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        <?php if($menuType == 'dedicated' && ($tnxType=='deposit'||$tnxType=='withdraw'||$tnxType=='referral')): ?>
                        <?php echo e(__(':Tnxtype', ['tnxtype' => $tnxType.(($tnxType=='withdraw') ? 'als' : 's')])); ?>

                        <?php else: ?> 
                        <?php echo e(__('Transactions')); ?>

                        <?php endif; ?>
                    </h3>
                    <p><?php echo __('Total :count transactions.', ['count' => '<span class="text-base">'.$transactions->total().'</span>']); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="#" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="pageMenu"><em class="icon ni ni-menu-alt-r"></em></a>
                        <div class="toggle-expand-content" data-content="pageMenu">
                            <ul class="nk-block-tools g-3">
                                
                                <li class="nk-block-tools-opt">
                                    <div class="btn-group">
                                        <button class="m-tnx-manual btn btn-primary" data-action="manual" data-view="any" data-backdrop="static"><em class="icon ni ni-plus"></em> <span><?php echo e(__("Add")); ?></span></button>
                                        <div class="btn-group dropdown">
                                            <button class="dropdown-toggle btn btn-icon btn-primary" data-toggle="dropdown"><em class="icon ni ni-chevron-down"></em></button>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <ul class="link-list-opt no-bdr">
                                                    <li><a href="javascript:void(0)" class="m-tnx-manual" data-action="manual" data-backdrop="static" data-view="deposit">
                                                        <em class="icon ni ni-wallet-in"></em><span><?php echo e(__('Add Deposit')); ?></span></a>
                                                    </li>
                                                    <li><a href="javascript:void(0)" class="m-tnx-manual" data-action="manual" data-backdrop="static" data-view="bonus">
                                                        <em class="icon ni ni-wallet-saving"></em><span><?php echo e(__('Add Bonus')); ?></span></a>
                                                    </li>
                                                    <li><a href="javascript:void(0)" class="m-tnx-manual" data-action="manual" data-backdrop="static" data-view="charge">
                                                        <em class="icon ni ni-wallet-out"></em><span><?php echo e(__('Add Charge')); ?></span></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <ul class="nk-nav nav nav-tabs mt-n3 mb-md-n3">
        <?php if($menuType == 'dedicated'): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.'.$tnxType.'.all') && $tnxStatus == 'any') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.'.$tnxType.'.all', ['status' => 'any'])); ?>">
                   <span><?php echo e(__('History')); ?></span></a>
            </li>
            
            <?php if($pendingCount > 0): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.'.$tnxType.'.all') && $tnxStatus == 'pending') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.'.$tnxType.'.all', ['status' => 'pending'])); ?>">
                   <span><?php echo e(__('Pending')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if($confirmedCount > 0): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.'.$tnxType.'.all') && $tnxStatus == 'confirmed') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.'.$tnxType.'.all', ['status' => 'confirmed'])); ?>">
                   <span><?php echo e(__('Confirmed')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if($onHoldCount > 0): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.'.$tnxType.'.all') && $tnxStatus == 'onhold') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.'.$tnxType.'.all', ['status' => 'onhold'])); ?>">
                   <span><?php echo e(__('On Hold')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if($processCount > 0): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.'.$tnxType.'.all') && $tnxStatus == 'process') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.'.$tnxType.'.all', ['status' => 'process'])); ?>">
                   <span><?php echo e(__('Proceed')); ?> <span class="badge badge-primary"><?php echo e($processCount); ?></span></span></a>
            </li>
            <?php endif; ?>
        <?php else: ?>
            <?php if($showAll || request()->routeIs('admin.transactions.list')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e(($menuType == 'history') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.list')); ?>"><span><?php echo e(__('History')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if($showAll || request()->routeIs('admin.transactions.confirmed')): ?>
                <?php if($confirmedCount > 0): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e((is_route('admin.transactions.confirmed') || $menuType == 'confirmed') ? 'active' : ''); ?>"
                       href="<?php echo e(route('admin.transactions.list', ['list_type' => 'confirmed'])); ?>">
                       <span><?php echo e(__('Confirmed')); ?></span></a>
                </li>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($showAll || request()->routeIs('admin.transactions.pending')): ?>
                <?php if($pendingCount > 0): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e((is_route('admin.transactions.pending') || $menuType == 'pending') ? 'active' : ''); ?>"
                       href="<?php echo e(route('admin.transactions.list', ['list_type' => 'pending'])); ?>">
                       <span><?php echo e(__('Pending')); ?></span></a>
                </li>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($showAll || request()->routeIs('admin.transactions.on-hold')): ?>
                <?php if($onHoldCount > 0): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e((is_route('admin.transactions.onhold') || $menuType == 'on-hold') ? 'active' : ''); ?>"
                       href="<?php echo e(route('admin.transactions.list', ['list_type' => 'on-hold'])); ?>">
                       <span><?php echo e(__('On Hold')); ?></span></a>
                </li>
                <?php endif; ?>
            <?php endif; ?>

            <?php if($showAll || request()->routeIs('admin.transactions.deposit')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.deposit') || $menuType == 'deposit') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.list', ['list_type' => 'deposit'])); ?>">
                   <span><?php echo e(__('Deposit')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if($showAll || request()->routeIs('admin.transactions.withdraw')): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo e((is_route('admin.transactions.withdraw') || $menuType == 'withdraw') ? 'active' : ''); ?>"
                   href="<?php echo e(route('admin.transactions.list', ['list_type' => 'withdraw'])); ?>">
                   <span><?php echo e(__('Withdraw')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if($showAll || request()->routeIs('admin.transactions.process')): ?>
                <?php if($processCount > 0): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo e((is_route('admin.transactions.process') || $menuType == 'process') ? 'active' : ''); ?>"
                    href="<?php echo e(route('admin.transactions.list', ['list_type' => 'process'])); ?>">
                    <span><?php echo e(__('Proceed')); ?> <span class="badge badge-primary"><?php echo e($processCount); ?></span></span></a>
                </li>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
        </ul>

        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h6 class="nk-block-title"><?php echo e(__('All Orders')); ?></h6>
                    </div>
                    <ul class="nk-block-tools gx-3">
                        <li>
                            <a href="#" class="search-toggle toggle-search btn btn-icon btn-trigger" data-target="search"><em class="icon ni ni-search"></em></a>
                        </li>
                        <li>
                            <div class="dropdown">
                                <a href="#" class="btn btn-trigger btn-icon dropdown-toggle" data-toggle="dropdown">
                                    <?php if(filter_count() > 0): ?>
                                        <div class="badge badge-circle badge-primary"> <?php echo e(filter_count()); ?> </div>
                                    <?php endif; ?>
                                    <em class="icon ni ni-filter-alt"></em>
                                </a>
                                <div class="filter-wg dropdown-menu dropdown-menu-xl dropdown-menu-right">
                                    <div class="dropdown-head">
                                        <span class="sub-title dropdown-title"><?php echo e(__('Advance Filter')); ?></span>
                                    </div>
                                    <form action="<?php echo e(route('admin.transactions.list')); ?>" method="GET">
                                        <input type="hidden" name="filter" value="true">
                                        <div class="dropdown-body dropdown-body-rg">
                                            <div class="row gx-6 gy-3">
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <label
                                                            class="overline-title overline-title-alt"><?php echo e(__('Type')); ?></label>
                                                        <select name="type" class="form-select form-select-sm">
                                                            <option value="any"><?php echo e(__('Any Type')); ?></option>
                                                            <?php $__currentLoopData = $transactionTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php if(request()->get('type') == $type): ?> selected
                                                                        <?php endif; ?>
                                                                        value="<?php echo e($type); ?>"><?php echo e(ucfirst(__($type))); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <label
                                                            class="overline-title overline-title-alt"><?php echo e(__('Status')); ?></label>
                                                        <select name="status" class="form-select form-select-sm">
                                                            <option value="any"><?php echo e(__('Any Status')); ?></option>
                                                            <?php $__currentLoopData = $transactionStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option
                                                                    <?php if(request()->get('status') == $status): ?> selected
                                                                    <?php endif; ?>
                                                                    value="<?php echo e($status); ?>"><?php echo e(ucfirst(__($status))); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <label
                                                            class="overline-title overline-title-alt"><?php echo e(__('Pay Currency')); ?></label>
                                                        <select name="currency" class="form-select form-select-sm">
                                                            <option value="any"><?php echo e(__('Any Currency')); ?></option>
                                                            <?php $__currentLoopData = $payCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php if(request()->get('currency') == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e(data_get($currency, 'name')); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <label class="overline-title overline-title-alt"><?php echo e(__('Method')); ?></label>
                                                        <select name="method" class="form-select form-select-sm">
                                                            <option value="any"><?php echo e(__('Any Method')); ?></option>
                                                            <?php $__currentLoopData = $tnxMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php if(request()->get('method') == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($item); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <div class="custom-control custom-control-sm custom-checkbox">
                                                            <input name="include_deleted" type="checkbox" class="custom-control-input"
                                                                   id="includeDel">
                                                            <label class="custom-control-label" for="includeDel">
                                                                <?php echo e(__('Including Deleted')); ?> </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="dropdown-foot between">
                                            <button type="submit" class="btn btn-secondary"><?php echo e(__('Filter')); ?></button>
                                            <a href="<?php echo e(route('admin.transactions.list')); ?>" class="clickable"><?php echo e(__('Reset Filter')); ?></a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="dropdown">
                                <a class="dropdown-toggle btn btn-icon btn-trigger mx-n1" data-toggle="dropdown"
                                   data-offset="-8,0" aria-expanded="false"><em class="icon ni ni-setting"></em></a>
                                <div class="dropdown-menu dropdown-menu-xs dropdown-menu-right" style="">
                                    <ul class="link-check">
                                        <li><span><?php echo e(__('Show')); ?></span></li>
                                        <?php $__currentLoopData = config('investorm.pgtn_pr_pg'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="update-meta<?php echo e((user_meta('tnx_perpage', '10') == $item) ? ' active' : ''); ?>">
                                            <a href="#" data-value="<?php echo e($item); ?>" data-meta="perpage" data-type="tnx"><?php echo e($item); ?></a>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <ul class="link-check">
                                        <li><span><?php echo e(__('Order')); ?></span></li>
                                        <?php $__currentLoopData = config('investorm.pgtn_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="update-meta<?php echo e((user_meta('tnx_order', 'asc') == $item) ? ' active' : ''); ?>">
                                            <a href="#" data-value="<?php echo e($item); ?>" data-meta="order" data-type="tnx"><?php echo e(__(strtoupper($item))); ?></a>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <ul class="link-check">
                                        <li><span><?php echo e(__('Density')); ?></span></li>
                                        <?php $__currentLoopData = config('investorm.pgtn_dnsty'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="update-meta<?php echo e((user_meta('tnx_display', 'regular') == $item) ? ' active' : ''); ?>">
                                            <a href="#" data-value="<?php echo e($item); ?>" data-meta="display" data-type="tnx"><?php echo e(__(ucfirst($item))); ?></a>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <form action="<?php echo e(url()->current()); ?>" method="GET">
                    <div class="search-wrap search-wrap-extend bg-lighter" data-search="search">
                        <div class="search-content">
                            <a href="#" class="search-back btn btn-icon toggle-search" data-target="search"><em class="icon ni ni-arrow-left"></em></a>
                            <input type="text" name="query" class="form-control border-transparent form-focus-none" placeholder="Search by Transaction id or User id">
                            <button class="search-submit btn btn-icon mr-1"><em class="icon ni ni-search"></em></button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="card card-bordered card-stretch">
                <div class="card-inner-group">
                    <?php if(filled($transactions)): ?>
                        <?php echo $__env->make('admin.transaction.transaction-table', ['transactions' => $transactions], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <div class="alert alert-primary">
                            <div class="alert-cta flex-wrap flex-md-nowrap">
                                <div class="alert-text">
                                    <p><?php echo e(__('No Transaction Found')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('modal'); ?>
<div class="modal fade" tabindex="-1" role="dialog" id="ajax-modal"></div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    const updateSetting = "<?php echo e(route('admin.profile.update')); ?>", 
        routes = { 
            view: "<?php echo e(route('admin.transaction.details')); ?>", 
            online: "<?php echo e(route('admin.transaction.status.check')); ?>", 
            approve: "<?php echo e(route('admin.transaction.update', 'approve')); ?>",
            reject: "<?php echo e(route('admin.transaction.update', 'reject')); ?>",
            confirm: "<?php echo e(route('admin.transaction.update', 'confirm')); ?>",
            manual: "<?php echo e(route('admin.transaction.manual.add')); ?>"
        },
        msgs = {
            completed: {
                title: "<?php echo e(__('Complete Transaction?')); ?>", 
                btn: {cancel: "<?php echo e(__('Cancel')); ?>", confirm: "<?php echo e(__('Yes, Procced')); ?>"}, 
                context: "<?php echo __("Please confirm that you want to procced the request and complete the transaction."); ?>", 
                custom: "success", type: "info" 
            },
            confirmed: { 
                title: "<?php echo e(__('Procced Withdraw?')); ?>", 
                btn: {cancel: "<?php echo e(__('Cancel')); ?>", confirm: "<?php echo e(__('Yes, Procced')); ?>"}, 
                context: "<?php echo __("Please confirm that you want to procced the request and send the payment."); ?>", 
                custom: "", type: "info" 
            },
            cancelled: { 
                title: "<?php echo e(__('Cancel Transaction?')); ?>", 
                btn: {cancel: "<?php echo e(__('No')); ?>", confirm: "<?php echo e(__('Yes, Cancel')); ?>"}, 
                context: "<?php echo __("You cannot revert back this action, so please confirm that you've not received the payment yet and want to cancel."); ?>", 
                custom: "danger", type: "warning" 
            },
            addnew: { 
                title: "<?php echo e(__('Add Manual Transaction?')); ?>", 
                btn: {cancel: "<?php echo e(__('No')); ?>", confirm: "<?php echo e(__('Yes, Procced')); ?>"}, 
                context: "<?php echo __("You cannot revert back this action, so please confirm that you want to add the transaction manually."); ?>", 
                custom: "success", type: "info" 
            }
        };
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/transaction/list.blade.php ENDPATH**/ ?>